<?php
// includes/plugin_system.php

$hooks = [];

// دالة إضافة الكود (للمبرمجين)
function add_action($hook_name, $callback) {
    global $hooks;
    $hooks[$hook_name][] = $callback;
}

// دالة تنفيذ الكود (للموقع)
function do_action($hook_name) {
    global $hooks;
    if (isset($hooks[$hook_name])) {
        foreach ($hooks[$hook_name] as $function) {
            if (function_exists($function)) {
                call_user_func($function);
            }
        }
    }
}

// تحميل البلوجينات المفعلة
// بنستخدم $pdo اللي موجودة في ملف الاتصال بتاعك
global $pdo;

// المسار لفولدر plugins (بنرجع خطوة لورا عشان احنا جوه includes)
$plugins_dir = __DIR__ . '/../plugins/';

if ($pdo) {
    try {
        $stmt = $pdo->query("SELECT plugin_key FROM app_plugins WHERE is_active = 1");
        if ($stmt) {
            $active_plugins = $stmt->fetchAll(PDO::FETCH_COLUMN);
            foreach ($active_plugins as $plugin_key) {
                $file = $plugins_dir . $plugin_key . '.php';
                if (file_exists($file)) {
                    include_once $file;
                }
            }
        }
    } catch (PDOException $e) {
        // تجاهل الخطأ لو الجدول لسه مش موجود
    }
}
?>