<?php
// admin/plugins.php
require_once '../includes/functions.php';

// التحقق من تسجيل الدخول
if(!isLoggedIn()) redirect('login.php');

// تشغيل نظام الإضافات (لضمان عمل الصفحات الخاصة بها)
if (file_exists('../includes/plugin_system.php')) {
    include_once '../includes/plugin_system.php';
}

$msg = '';
$error = '';

// ============================================================
// 1. كود معالجة حذف الإضافة (تم تطويره ليحذف الجداول) 🌟
// ============================================================
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['key'])) {
    $key_to_delete = $_GET['key'];
    
    // حماية بسيطة: التأكد أن المفتاح حروف وأرقام فقط
    if (preg_match('/^[a-zA-Z0-9_]+$/', $key_to_delete)) {
        
        $file_path = "../plugins/{$key_to_delete}.php";
        
        // --- [بداية التعديل الذكي] ---
        // قبل حذف الملف، نقرأه لنعرف الجداول التي أنشأها ونحذفها
        if (file_exists($file_path)) {
            // 1. قراءة محتوى الملف
            $code = file_get_contents($file_path);
            
            // 2. البحث عن أوامر إنشاء الجداول (CREATE TABLE)
            // هذا الكود يستخرج اسم الجدول تلقائياً من داخل ملف الإضافة
            preg_match_all('/CREATE\s+TABLE\s+(?:IF\s+NOT\s+EXISTS\s+)?[`]?([a-zA-Z0-9_]+)[`]?/i', $code, $matches);
            
            if (!empty($matches[1])) {
                // جداول ممنوع حذفها (حماية للنظام)
                $protected = ['orders', 'products', 'settings', 'app_plugins', 'users', 'categories'];
                
                foreach ($matches[1] as $table) {
                    if (!in_array($table, $protected)) {
                        try {
                            $pdo->exec("DROP TABLE IF EXISTS `$table`");
                        } catch (Exception $e) { /* استمر حتى لو في خطأ */ }
                    }
                }
            }
            
            // 3. حذف الملف من السيرفر
            unlink($file_path); 
        }
        // --- [نهاية التعديل الذكي] ---

        // 4. حذف السجل من قاعدة البيانات
        try {
            $stmt = $pdo->prepare("DELETE FROM app_plugins WHERE plugin_key = ?");
            $stmt->execute([$key_to_delete]);
            
            // تنظيف إضافي (يدوي) لبعض الإضافات القديمة جداً إن وجدت
            if($key_to_delete == 'hero_pro') $pdo->exec("DROP TABLE IF EXISTS hero_settings");
            if($key_to_delete == 'ultimate_customizer') $pdo->exec("DROP TABLE IF EXISTS site_options, categories");

            $msg = "تم حذف الإضافة وتنظيف جميع جداولها من قاعدة البيانات 🗑️";
        } catch (Exception $e) {
            $error = "حدث خطأ أثناء الحذف من قاعدة البيانات.";
        }
    }
}

// ==========================================
// 2. كود معالجة رفع إضافة جديدة (الكود الأصلي)
// ==========================================
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['upload_plugin'])) {
    $p_name = trim($_POST['plugin_name']);
    $p_key  = trim($_POST['plugin_key']);
    
    // التحقق من الملف
    if (isset($_FILES['plugin_file']) && $_FILES['plugin_file']['error'] == 0) {
        $file_ext = pathinfo($_FILES['plugin_file']['name'], PATHINFO_EXTENSION);
        
        // السماح فقط بملفات PHP
        if ($file_ext == 'php') {
            $target_dir = '../plugins/';
            
            // إنشاء المجلد لو مش موجود
            if (!is_dir($target_dir)) {
                mkdir($target_dir, 0755, true);
            }
            
            $target_file = $target_dir . $p_key . '.php';
            
            // رفع الملف
            if (move_uploaded_file($_FILES['plugin_file']['tmp_name'], $target_file)) {
                try {
                    // التأكد إن الجدول موجود (لأول مرة)
                    $pdo->exec("CREATE TABLE IF NOT EXISTS `app_plugins` (
                        `id` int(11) NOT NULL AUTO_INCREMENT,
                        `plugin_key` varchar(50) NOT NULL,
                        `plugin_name` varchar(100) NOT NULL,
                        `is_active` tinyint(1) DEFAULT 0,
                        `settings` text DEFAULT NULL,
                        PRIMARY KEY (`id`),
                        UNIQUE KEY `plugin_key` (`plugin_key`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

                    // التأكد إن المفتاح مش مكرر
                    $check = $pdo->prepare("SELECT id FROM app_plugins WHERE plugin_key = ?");
                    $check->execute([$p_key]);
                    
                    if ($check->rowCount() == 0) {
                        // إدخال جديد
                        $stmt = $pdo->prepare("INSERT INTO app_plugins (plugin_key, plugin_name, is_active, settings) VALUES (?, ?, 0, '{}')");
                        $stmt->execute([$p_key, $p_name]);
                        $msg = "تم رفع وتثبيت الإضافة بنجاح! 🎉";
                    } else {
                        // لو موجود، نحدث الاسم بس (أو نعتبره تحديث للملف)
                        $msg = "تم تحديث ملف الإضافة بنجاح.";
                    }
                } catch (Exception $e) {
                    $error = "خطأ في قاعدة البيانات: " . $e->getMessage();
                }
            } else {
                $error = "فشل في نقل الملف إلى مجلد plugins.";
            }
        } else {
            $error = "يجب أن يكون الملف بصيغة PHP فقط.";
        }
    } else {
        $error = "يرجى اختيار ملف.";
    }
}

// ==========================================
// 3. كود حفظ حالة التفعيل (Active/Inactive)
// ==========================================
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_active_status'])) {
    // تصفير الجميع
    $pdo->query("UPDATE app_plugins SET is_active = 0");
    
    // تفعيل المختارين
    if (isset($_POST['active_plugins'])) {
        $stmt = $pdo->prepare("UPDATE app_plugins SET is_active = 1 WHERE plugin_key = ?");
        foreach ($_POST['active_plugins'] as $key => $val) {
            $stmt->execute([$key]);
        }
    }
    $msg = "تم حفظ التغييرات بنجاح ✅";
}

// ==========================================
// 4. جلب قائمة الإضافات للعرض
// ==========================================
$plugins_list = [];
try {
    // نتأكد إن الجدول موجود عشان الصفحة متضربش لو لسه جديد
    $check_table = $pdo->query("SHOW TABLES LIKE 'app_plugins'");
    if($check_table->rowCount() > 0) {
        $plugins_list = $pdo->query("SELECT * FROM app_plugins ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    }
} catch (Exception $e) {}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الإضافات - لوحة التحكم</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Cairo', sans-serif; }
        /* زر التبديل (Switch) */
        .switch { position: relative; display: inline-block; width: 44px; height: 24px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
        .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
        input:checked + .slider { background-color: #10b981; }
        input:checked + .slider:before { transform: translateX(20px); }
    </style>
</head>
<body class="bg-gray-50">

<div class="flex h-screen overflow-hidden">
    
    <aside class="w-64 bg-slate-900 text-white hidden md:flex flex-col shadow-2xl">
        <div class="h-20 flex items-center justify-center border-b border-slate-800">
            <h2 class="text-2xl font-bold text-emerald-400">WhatsCart</h2>
        </div>
        
        <nav class="flex-1 px-4 py-6 space-y-2 overflow-y-auto">
            <a href="index.php" class="flex items-center gap-3 px-4 py-3 text-slate-300 hover:bg-slate-800 hover:text-white rounded-xl transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" /></svg>
                الرئيسية
            </a>

            <a href="products.php" class="flex items-center gap-3 px-4 py-3 text-slate-300 hover:bg-slate-800 hover:text-white rounded-xl transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" /></svg>
                المنتجات
            </a>
            
            <a href="plugins.php" class="flex items-center gap-3 px-4 py-3 bg-emerald-600 text-white rounded-xl shadow-lg transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a2 2 0 012 2v6a2 2 0 01-2 2H9a2 2 0 01-2-2V6a2 2 0 012-2h2.5L11 4zm5 4h.01M8 16h.01" /></svg>
                الإضافات
            </a>

            <?php if(function_exists('do_action')) do_action('admin_sidebar'); ?>
            
            <div class="border-t border-slate-800 my-2"></div>

            <a href="settings.php" class="flex items-center gap-3 px-4 py-3 text-slate-300 hover:bg-slate-800 hover:text-white rounded-xl transition">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                الإعدادات
            </a>
        </nav>

        <div class="p-4 border-t border-slate-800">
            <a href="logout.php" class="flex items-center gap-2 text-red-400 hover:text-red-300 transition text-sm font-bold">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" /></svg>
                تسجيل خروج
            </a>
        </div>
    </aside>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 md:hidden flex justify-between items-center">
            <span class="font-bold text-lg text-emerald-600">WhatsCart</span>
            <a href="logout.php" class="text-red-500 text-sm">خروج</a>
        </header>

        <div class="p-8">
            <h1 class="text-2xl font-bold text-gray-800 mb-6">🧩 إدارة الإضافات (Plugins)</h1>

            <?php if ($msg): ?> 
            <div class="bg-green-100 border border-green-200 text-green-700 px-4 py-3 rounded-xl mb-4 flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                <?= $msg ?>
            </div> 
            <?php endif; ?>
            
            <?php if ($error): ?> 
            <div class="bg-red-100 border border-red-200 text-red-700 px-4 py-3 rounded-xl mb-4 flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                <?= $error ?>
            </div> 
            <?php endif; ?>

            <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 mb-8">
                <div class="flex items-center gap-2 mb-4">
                    <div class="p-2 bg-indigo-50 text-indigo-600 rounded-lg">
                        <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" /></svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-800">رفع إضافة جديدة</h3>
                </div>

                <form method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-12 gap-4 items-end">
                    <div class="md:col-span-4">
                        <label class="block text-sm font-bold text-gray-600 mb-1">اسم الإضافة</label>
                        <input type="text" name="plugin_name" placeholder="مثال: سجل الطلبات CRM" class="w-full p-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none" required>
                    </div>
                    
                    <div class="md:col-span-3">
                        <label class="block text-sm font-bold text-gray-600 mb-1">المفتاح (Key)</label>
                        <input type="text" name="plugin_key" placeholder="english_code_only" class="w-full p-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:outline-none" required>
                    </div>

                    <div class="md:col-span-3">
                        <label class="block text-sm font-bold text-gray-600 mb-1">ملف الإضافة (.php)</label>
                        <input type="file" name="plugin_file" accept=".php" class="w-full p-2 border border-gray-300 rounded-lg bg-gray-50 text-sm file:mr-4 file:py-1 file:px-2 file:rounded-md file:border-0 file:text-xs file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100" required>
                    </div>
                    
                    <div class="md:col-span-2">
                        <button type="submit" name="upload_plugin" class="w-full bg-indigo-600 text-white py-2.5 rounded-lg font-bold hover:bg-indigo-700 transition shadow-lg shadow-indigo-200">رفع وتثبيت</button>
                    </div>
                </form>
            </div>

            <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
                <div class="flex items-center gap-2 mb-6">
                    <div class="p-2 bg-emerald-50 text-emerald-600 rounded-lg">
                        <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" /></svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-800">الإضافات المثبتة</h3>
                </div>

                <form method="POST">
                    <?php if (count($plugins_list) > 0): ?>
                        <div class="grid grid-cols-1 gap-4">
                        <?php foreach ($plugins_list as $p): ?>
                            <div class="flex items-center justify-between p-4 border border-gray-100 rounded-xl hover:bg-gray-50 transition group">
                                <div class="flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-full bg-gray-200 flex items-center justify-center text-gray-500 font-bold text-lg group-hover:bg-indigo-100 group-hover:text-indigo-600 transition">
                                        <?= mb_substr($p['plugin_name'], 0, 1, 'UTF-8') ?>
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-800 text-lg"><?= htmlspecialchars($p['plugin_name']) ?></h3>
                                        <div class="flex items-center gap-2 text-xs text-gray-500">
                                            <span class="bg-gray-100 px-2 py-0.5 rounded border">Key: <?= $p['plugin_key'] ?></span>
                                            <span>•</span>
                                            <span>plugins/<?= $p['plugin_key'] ?>.php</span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="flex items-center gap-4">
                                    <a href="?action=delete&key=<?= $p['plugin_key'] ?>" onclick="return confirm('⚠️ هل أنت متأكد من حذف هذه الإضافة نهائياً؟\nسيتم حذف الملف وإزالة جداول البيانات المرتبطة به تلقائياً.')" class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition" title="حذف الإضافة">
                                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" /></svg>
                                    </a>

                                    <label class="switch">
                                        <input type="checkbox" name="active_plugins[<?= $p['plugin_key'] ?>]" <?= $p['is_active'] ? 'checked' : '' ?>>
                                        <span class="slider shadow-sm"></span>
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        </div>
                        
                        <div class="mt-8 flex justify-end">
                            <button type="submit" name="save_active_status" class="bg-emerald-600 text-white px-8 py-3 rounded-xl font-bold hover:bg-emerald-700 transition shadow-lg shadow-emerald-200 flex items-center gap-2">
                                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                حفظ حالة التفعيل
                            </button>
                        </div>

                    <?php else: ?>
                        <div class="text-center py-16 bg-gray-50 rounded-xl border border-dashed border-gray-200">
                            <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" /></svg>
                            <p class="text-gray-500 font-medium">لا توجد إضافات مثبتة حتى الآن.</p>
                            <p class="text-sm text-gray-400 mt-1">استخدم النموذج بالأعلى لرفع أول إضافة لك.</p>
                        </div>
                    <?php endif; ?>
                </form>
            </div>

        </div>
    </main>
</div>

</body>
</html>