<?php
// includes/functions.php
require_once 'config.php';
require_once 'lang.php';

function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function redirect($url) {
    header("Location: $url");
    exit;
}

function getSetting($key) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute([$key]);
    return $stmt->fetchColumn();
}

// ============================================================
// دالة خصم المخزون عند تأكيد الطلب (محسنة)
// ============================================================
function deductStockFromOrder($cartItems) {
    global $pdo;
    
    try {
        // نمر على كل عنصر في سلة المشتريات
        foreach ($cartItems as $item) {
            
            if (isset($item['id'])) {
                $productId = $item['id'];
                $qtyToDeduct = (int)$item['qty'];

                // جلب البيانات الحالية للمنتج
                $stmt = $pdo->prepare("SELECT custom_sizes FROM products WHERE id = ?");
                $stmt->execute([$productId]);
                $product = $stmt->fetch();

                if ($product && !empty($product['custom_sizes'])) {
                    // فك ترميز بيانات المخزون (JSON)
                    $variants = json_decode($product['custom_sizes'], true);
                    
                    // نتأكد أن البيانات سليمة (مصفوفة)
                    if (is_array($variants) && count($variants) > 0) {
                        $isUpdated = false;

                        // الحالة 1: المنتج له تنوع محدد (مقاس + لون)
                        if (isset($item['variant_size']) && isset($item['variant_color'])) {
                            $requestedSize = $item['variant_size'];
                            $requestedColor = $item['variant_color'];

                            foreach ($variants as &$variant) {
                                if (
                                    isset($variant['size']) && $variant['size'] === $requestedSize &&
                                    isset($variant['color']) && $variant['color'] === $requestedColor
                                ) {
                                    if (isset($variant['qty']) && $variant['qty'] >= $qtyToDeduct) {
                                        $variant['qty'] -= $qtyToDeduct;
                                        $isUpdated = true;
                                    }
                                    break;
                                }
                            }
                        } 
                        // الحالة 2: منتج بسيط (لم يتم اختيار مقاس أو لون في السلة)
                        // نقوم بخصم الكمية من "أول" متجر موجود تلقائياً
                        else {
                            if (isset($variants[0]['qty'])) {
                                $variants[0]['qty'] -= $qtyToDeduct;
                                $isUpdated = true;
                            }
                        }

                        // تحديث قاعدة البيانات إذا حدث تغيير
                        if ($isUpdated) {
                            $newJson = json_encode($variants, JSON_UNESCAPED_UNICODE);
                            $updateStmt = $pdo->prepare("UPDATE products SET custom_sizes = ? WHERE id = ?");
                            $updateStmt->execute([$newJson, $productId]);
                        }
                    }
                }
            }
        }
        return true; // نجحت العملية
    } catch (Exception $e) {
        // في حال وجود خطأ غير متوقع، نسجله في سجلات الأخطاء ولا نوقف الموقع
        error_log("Stock Deduction Error: " . $e->getMessage());
        return false;
    }
}
?>