<?php
// includes/plugin_system.php

// 1. مصفوفة الهوكس
$app_hooks = [];

// 2. دالة إضافة هوك
function add_action($hook_name, $function_to_add) {
    global $app_hooks;
    $app_hooks[$hook_name][] = $function_to_add;
}

// 3. دالة تنفيذ الهوك
function do_action($hook_name, $arg = null) {
    global $app_hooks;
    if (isset($app_hooks[$hook_name])) {
        foreach ($app_hooks[$hook_name] as $function) {
            if (function_exists($function)) {
                call_user_func($function, $arg);
            }
        }
    }
}

// ============================================================
// 4. [الجزء الذي كان ناقص] تحميل الإضافات المفعلة من الداتا بيز
// ============================================================
global $pdo;

// نتأكد أن الاتصال بقاعدة البيانات موجود
if (isset($pdo)) {
    try {
        // نتأكد أن الجدول موجود أصلاً لتجنب الأخطاء في البداية
        $check_table = $pdo->query("SHOW TABLES LIKE 'app_plugins'");
        
        if ($check_table->rowCount() > 0) {
            // نجلب فقط الإضافات التي حالتها = 1 (مفعلة)
            $active_plugins = $pdo->query("SELECT plugin_key FROM app_plugins WHERE is_active = 1");
            
            while ($plugin = $active_plugins->fetch(PDO::FETCH_ASSOC)) {
                // نحدد مسار الملف
                // __DIR__ تعني المجلد الحالي (includes)، فنخرج خطوة للخلف (..) ثم ندخل plugins
                $plugin_file = __DIR__ . '/../plugins/' . $plugin['plugin_key'] . '.php';
                
                // لو الملف موجود، نقوم بتضمينه (تشغيله)
                if (file_exists($plugin_file)) {
                    include_once $plugin_file;
                }
            }
        }
    } catch (Exception $e) {
        // لو حصل خطأ هنا نفضل ساكتين عشان الموقع ميوقتش
    }
}
?>