<?php
// index.php
require_once 'includes/functions.php';

// 1. تشغيل نظام الإضافات
if (file_exists(__DIR__ . '/includes/plugin_system.php')) {
    include_once __DIR__ . '/includes/plugin_system.php';
}

// 2. التحقق من وجود ثيم نشط
 $active_theme = '';
if (function_exists('tm_get_opt')) {
    $active_theme = tm_get_opt('active_theme', '');
}

// 3. معالجة طلبات AJAX (إرسال الطلب) + خصم المخزون
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'submit_order') {
    header('Content-Type: application/json');
    try {
        $order_data = [
            'name'     => $_POST['name'] ?? 'ضيف',
            'phone'    => $_POST['phone'] ?? 'غير موجود',
            'address'  => $_POST['address'] ?? 'غير محدد',
            'cart'     => json_decode($_POST['cart'] ?? '[]', true),
            'total'    => $_POST['total'] ?? 0,
            'message'  => $_POST['wa_message'] ?? '',
            'date'     => date('Y-m-d H:i:s')
        ];

        if (function_exists('do_action')) {
            do_action('on_order_created', $order_data); 
        }

        // استدعاء دالة خصم المخزون
        if (function_exists('deductStockFromOrder')) {
            deductStockFromOrder($order_data['cart']);
        }

        echo json_encode(['status' => 'success']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'success']);
    }
    exit;
}

// 4. جلب الفئات (للفلتر)
 $categories = [];
try {
    $categories = $pdo->query("SELECT * FROM categories ORDER BY id DESC")->fetchAll();
} catch(Exception $e) { }

// 5. جلب المنتجات مع الفلترة والبحث
 $whereClause = ["active = 1"];
 $params = [];

// فلترة بالبحث
 $search_query = $_GET['q'] ?? '';
if (!empty($search_query)) {
    $whereClause[] = "(title LIKE ? OR description LIKE ?)";
    $params[] = "%$search_query%";
    $params[] = "%$search_query%";
}

// فلترة بالقسم
 $category_filter = isset($_GET['cat']) ? (int)$_GET['cat'] : 0;
if ($category_filter > 0) {
    $whereClause[] = "category_id = ?";
    $params[] = $category_filter;
}

 $sql = "SELECT * FROM products WHERE " . implode(" AND ", $whereClause) . " ORDER BY id DESC";
 $stmt = $pdo->prepare($sql);
 $stmt->execute($params);
 $products = $stmt->fetchAll();

 $site_title = getSetting('site_title');
 $whatsapp   = getSetting('whatsapp');
 $currency   = getSetting('currency');
 $current_lang = $_SESSION['lang'] ?? 'ar';
 $dir = ($current_lang == 'ar') ? 'rtl' : 'ltr';

// نصوص الواجهة
 $btn_text = ($current_lang == 'ar') ? 'إتمام الطلب عبر واتساب' : 'Checkout via WhatsApp';
 $loading_text = ($current_lang == 'ar') ? 'جاري التحويل...' : 'Processing...';
 $fill_msg = ($current_lang == 'ar') ? 'الرجاء إدخال الاسم ورقم الهاتف والعنوان' : 'Please fill name, phone and address';
 $select_msg = ($current_lang == 'ar') ? 'الرجاء اختيار اللون والمقاس أولاً' : 'Please select color and size first';
 $order_msg_title = ($current_lang == 'ar') ? 'طلب جديد' : 'New Order';
 $sale_text = ($current_lang == 'ar') ? 'خصم' : 'SALE';
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>" dir="<?= $dir ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?= e($site_title) ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800&family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/css/style.css">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js"></script>
    
    <?php if(function_exists('do_action')) do_action('site_head'); ?>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['<?= ($current_lang == "ar") ? "Cairo" : "Inter" ?>', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#f0fdf4',
                            100: '#dcfce7',
                            500: '#22c55e',
                            600: '#16a34a',
                            700: '#15803d',
                            900: '#14532d',
                        }
                    }
                }
            }
        }
    </script>

    <style>
        [x-cloak] { display: none !important; }
        .fade-in { animation: fadeIn 0.6s cubic-bezier(0.16, 1, 0.3, 1); }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        ::-webkit-scrollbar { width: 6px; height: 4px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        
        .glass-nav {
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.3);
        }
        .card-hover-effect { transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .card-hover-effect:hover { transform: translateY(-5px); box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1); }
        
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }

        <?php if($active_theme): ?>
            body nav.bg-white, body main.max-w-4xl { display: none !important; }
            body { padding-top: 0 !important; background: #fff; }
        <?php endif; ?>
    </style>
</head>

<body class="bg-slate-50 text-slate-800 font-sans antialiased selection:bg-primary-500 selection:text-white"
      x-data="app()"
      x-init="whatsappNumber = '<?= $whatsapp ?>'; currencySymbol = '<?= $currency ?>';">

    <?php if(function_exists('do_action')) do_action('top_bar_ads'); ?>

    <nav class="glass-nav fixed top-0 w-full z-40 transition-all duration-300">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <a href="index.php" class="flex-shrink-0 flex items-center gap-2 cursor-pointer">
                    <div class="w-8 h-8 rounded-lg bg-gradient-to-br from-primary-500 to-primary-700 flex items-center justify-center text-white font-bold text-lg shadow-lg">
                        <?= mb_substr($site_title, 0, 1) ?>
                    </div>
                    <h1 class="text-xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-slate-800 to-slate-600 tracking-tight">
                        <?= e($site_title) ?>
                    </h1>
                </a>

                <div class="flex items-center gap-3">
                    <a href="?lang=<?= $current_lang == 'en' ? 'ar' : 'en' ?>" 
                       class="text-xs font-bold text-slate-500 hover:text-primary-600 border border-slate-200 hover:border-primary-500 hover:bg-primary-50 px-2 py-1 rounded-md transition-all duration-200">
                        <?= $current_lang == 'en' ? 'AR' : 'EN' ?>
                    </a>
                    
                    <button @click="cartOpen = true" class="relative group p-2 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                        <div class="absolute -top-1 -right-1 z-10">
                            <span x-show="count > 0" x-transition.scale.origin.center
                                  class="flex items-center justify-center w-5 h-5 bg-red-500 text-white text-[10px] font-bold rounded-full shadow-md border-2 border-white" 
                                  x-text="count"></span>
                        </div>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-slate-600 group-hover:text-primary-600 transition-colors" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <?php if(function_exists('do_action')) do_action('after_navbar'); ?>
    <?php if(function_exists('do_action')) do_action('custom_theme_view'); ?>

    <main class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 pt-24 pb-24 fade-in">
        
        <?php if(function_exists('do_action')) do_action('before_products'); ?>

        <div class="mb-8 space-y-6">
            <form action="index.php" method="GET" class="relative max-w-lg mx-auto">
                <input type="text" name="q" value="<?= htmlspecialchars($search_query) ?>" 
                       placeholder="<?= ($current_lang == 'ar') ? 'ابحث عن منتج...' : 'Search for products...' ?>"
                       class="w-full pl-12 pr-4 py-3.5 rounded-2xl border border-slate-200 shadow-sm focus:border-primary-500 focus:ring-4 focus:ring-primary-100 transition-all outline-none text-sm font-medium">
                <button type="submit" class="absolute left-3 top-1/2 -translate-y-1/2 text-slate-400 hover:text-primary-600">
                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" /></svg>
                </button>
                <?php if($category_filter > 0): ?>
                    <input type="hidden" name="cat" value="<?= $category_filter ?>">
                <?php endif; ?>
            </form>

            <?php if(!empty($categories)): ?>
            <div class="flex gap-2 overflow-x-auto no-scrollbar pb-2 mask-linear">
                <a href="index.php<?= !empty($search_query) ? '?q='.urlencode($search_query) : '' ?>" 
                   class="px-5 py-2.5 rounded-full text-sm font-bold whitespace-nowrap transition-all duration-200 border flex-shrink-0 
                   <?= ($category_filter == 0) ? 'bg-slate-800 text-white border-slate-800 shadow-lg shadow-slate-800/20' : 'bg-white text-slate-600 border-slate-200 hover:border-slate-300 hover:bg-slate-50' ?>">
                   <?= ($current_lang == 'ar') ? 'الكل' : 'All' ?>
                </a>
                
                <?php foreach($categories as $cat): 
                    $isActive = ($category_filter == $cat['id']);
                    $url = "index.php?cat=" . $cat['id'] . (!empty($search_query) ? '&q='.urlencode($search_query) : '');
                ?>
                <a href="<?= $url ?>" 
                   class="px-5 py-2.5 rounded-full text-sm font-bold whitespace-nowrap transition-all duration-200 border flex-shrink-0 
                   <?= $isActive ? 'bg-slate-800 text-white border-slate-800 shadow-lg shadow-slate-800/20' : 'bg-white text-slate-600 border-slate-200 hover:border-slate-300 hover:bg-slate-50' ?>">
                   <?= e($cat['name']) ?>
                </a>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>

        <div class="mb-4 flex items-center justify-between">
            <h2 class="text-xl font-bold text-slate-800 flex items-center gap-2">
                <?= __('home') ?>
                <?php if($category_filter > 0): ?>
                    <span class="text-slate-400 text-sm font-normal">/ تصفح الفئة</span>
                <?php endif; ?>
                <?php if(!empty($search_query)): ?>
                    <span class="text-slate-400 text-sm font-normal">/ نتائج البحث</span>
                <?php endif; ?>
            </h2>
            <span class="text-xs text-slate-500 font-bold bg-slate-100 px-2 py-1 rounded"><?= count($products) ?> منتج</span>
        </div>

        <!-- Grid Products -->
        <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-3 gap-3 md:gap-6 lg:gap-8">
            <?php foreach($products as $p): 
                $price = (float)$p['price'];
                $old_price = isset($p['old_price']) ? (float)$p['old_price'] : 0;
                $has_discount = ($old_price > $price);
                
                $discount_percent = 0;
                if($has_discount && $old_price > 0) {
                    $discount_percent = round((($old_price - $price) / $old_price) * 100);
                }

                // **تعديل هام: توحيد البيانات (Normalization)**
                $productVariants = [];
                $rawJson = !empty($p['custom_sizes']) ? json_decode($p['custom_sizes'], true) : [];
                
                // التحقق من النظام الجديد (مصفوفة متغيرات كاملة)
                $isNewSystem = false;
                if (isset($rawJson[0]['color']) && isset($rawJson[0]['size'])) {
                    $isNewSystem = true;
                    $productVariants = $rawJson;
                } else {
                    // **محاكاة النظام القديم للتوافق**
                    $rawColors = !empty($p['custom_colors']) ? json_decode($p['custom_colors'], true) : [];
                    $rawSizes = $rawJson; // المقاسات غالباً في custom_sizes
                    
                    $cleanColors = [];
                    if (is_array($rawColors)) {
                        foreach ($rawColors as $c) {
                            if (is_array($c) && isset($c['color'])) $cleanColors[] = $c['color'];
                            elseif (is_string($c)) $cleanColors[] = $c;
                        }
                    }
                    if (empty($cleanColors)) $cleanColors = ['#000000']; // لون افتراضي

                    $cleanSizes = [];
                    if (is_array($rawSizes)) {
                        foreach ($rawSizes as $s) {
                            if (is_array($s) && isset($s['size'])) $cleanSizes[] = $s['size'];
                            elseif (is_string($s)) $cleanSizes[] = $s;
                        }
                    }
                    if (empty($cleanSizes)) $cleanSizes = ['Free Size']; // مقاس افتراضي

                    // إنشاء Cartesian Product (كل لون مع كل مقاس) ليعمل نظام الفلترة
                    if(!empty($cleanColors) && !empty($cleanSizes)) {
                        foreach ($cleanColors as $color) {
                            foreach ($cleanSizes as $size) {
                                $productVariants[] = [
                                    'color' => $color,
                                    'size' => $size,
                                    'qty' => 999 // القيمة الافتراضية للنظام القديم
                                ];
                            }
                        }
                    }
                }

                $alpineData = htmlspecialchars(json_encode([
                    'id' => $p['id'],
                    'title' => $p['title'],
                    'price' => $price,
                    'image' => 'assets/uploads/' . $p['image'],
                    'variants' => $productVariants // إرسال البيانات الموحدة
                ]), ENT_QUOTES, 'UTF-8');
            ?>
            
            <div x-data="productItem(<?= $alpineData ?>)" 
                 class="product-card group bg-white rounded-2xl overflow-hidden border border-slate-100 shadow-sm card-hover-effect flex flex-col relative h-full">
                
                <a href="product.php?id=<?= $p['id'] ?>" class="block relative aspect-[4/3] overflow-hidden bg-slate-100">
                    <?php if($has_discount): ?>
                    <div class="absolute top-2 <?= ($dir == 'rtl') ? 'right-2' : 'left-2' ?> z-20">
                        <span class="bg-red-500 text-white text-[10px] font-bold px-2 py-0.5 rounded-full shadow-lg">
                            <?= $sale_text ?> <?= $discount_percent ?>%
                        </span>
                    </div>
                    <?php endif; ?>

                    <img src="assets/uploads/<?= e($p['image']) ?>" 
                         alt="<?= e($p['title']) ?>" 
                         loading="lazy" 
                         class="w-full h-full object-cover transition duration-700 ease-out group-hover:scale-110"
                         onerror="this.src='https://placehold.co/600x400/f1f5f9/94a3b8?text=No+Image'">
                </a>

                <div class="p-3 md:p-6 flex-1 flex flex-col gap-2 md:gap-4">
                    <div>
                        <a href="product.php?id=<?= $p['id'] ?>" class="block group-hover:text-primary-600 transition-colors duration-200">
                            <h3 class="font-bold text-slate-800 text-sm md:text-lg line-clamp-1 leading-snug"><?= e($p['title']) ?></h3>
                        </a>
                        
                        <?php if(!empty($p['description'])): ?>
                        <p class="hidden sm:block text-xs text-slate-500 mt-2 line-clamp-2 h-9 overflow-hidden"><?= e($p['description']) ?></p>
                        <?php else: ?>
                        <div class="hidden sm:block h-9"></div>
                        <?php endif; ?>
                    </div>

                    <!-- منطق اختيار المتغيرات (تبعية) -->
                    <div class="space-y-2">
                        <div x-show="availableColors && availableColors.length > 0">
                            <div class="flex flex-wrap gap-1 md:gap-2 items-center">
                                <span class="text-[9px] md:text-[10px] font-bold text-slate-400 uppercase tracking-wider hidden sm:inline">لون</span>
                                <template x-for="color in availableColors">
                                    <button @click="selectColor(color.color)"
                                            :disabled="!color.inStock"
                                            :class="{
                                                'ring-2 ring-offset-2 ring-primary-500 scale-110': selectedColor === color.color,
                                                'hover:scale-105 hover:shadow-md': selectedColor !== color.color && color.inStock,
                                                'opacity-30 cursor-not-allowed': !color.inStock
                                            }"
                                            class="w-5 h-5 md:w-6 md:h-6 rounded-full border border-slate-200 transition-all duration-200 relative focus:outline-none"
                                            :style="'background-color: ' + color.color">
                                        <span x-show="!color.inStock" class="absolute inset-0 flex items-center justify-center text-red-500 font-bold text-[10px] pointer-events-none">x</span>
                                    </button>
                                </template>
                            </div>
                        </div>

                        <div x-show="availableSizes && availableSizes.length > 0">
                            <div class="flex flex-wrap gap-1 md:gap-2">
                                <template x-for="s in availableSizes">
                                    <button @click="selectSize(s.size)"
                                            :disabled="!s.inStock"
                                            :class="{
                                                'bg-primary-600 text-white border-primary-600 shadow-md': selectedSize === s.size,
                                                'bg-white text-slate-600 border-slate-200 hover:border-primary-400': selectedSize !== s.size && s.inStock,
                                                'bg-slate-50 text-slate-300 border-slate-100 cursor-not-allowed line-through': !s.inStock
                                            }"
                                            class="px-2 py-1 md:px-2.5 md:py-1 rounded-lg border text-[10px] md:text-[11px] font-bold transition-all duration-200 min-w-[2.5rem]">
                                        <span x-text="s.size"></span>
                                    </button>
                                </template>
                            </div>
                        </div>
                    </div>

                    <div class="mt-auto pt-2 md:pt-4 border-t border-slate-100 flex items-center justify-between gap-2 md:gap-4">
                        <div class="flex flex-col">
                            <?php if($has_discount): ?>
                            <span class="text-[10px] md:text-[11px] text-red-400 line-through font-semibold">
                                <?= number_format($old_price, 2) ?>
                            </span>
                            <?php endif; ?>
                            <div class="flex items-baseline gap-1">
                                <span class="text-slate-800 font-extrabold text-base md:text-xl leading-none">
                                    <?= number_format($price, 2) ?>
                                </span>
                                <small class="text-[9px] md:text-[10px] text-slate-500 font-medium uppercase"><?= $currency ?></small>
                            </div>
                        </div>
                        
                        <button @click="addToCart()" 
                                class="flex-1 bg-slate-900 text-white px-2 py-2 md:px-4 md:py-3 rounded-lg md:rounded-xl flex items-center justify-center gap-1 md:gap-2 hover:bg-primary-600 transition-all duration-300 shadow-lg shadow-slate-900/20 active:scale-95 duration-200 group/btn">
                            <span class="text-[10px] md:text-sm font-bold">إضافة</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5 md:h-4 md:w-4 transition-transform group-hover/btn:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <?php if(count($products) == 0): ?>
            <div class="flex flex-col items-center justify-center py-20 text-slate-400 bg-white rounded-3xl border border-dashed border-slate-200">
                <svg class="w-16 h-16 mb-4 text-slate-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                <p class="text-lg font-medium">لا توجد منتجات تطابق بحثك</p>
                <a href="index.php" class="mt-4 text-primary-600 hover:underline text-sm font-bold">عرض جميع المنتجات</a>
            </div>
        <?php endif; ?>

        <?php if(function_exists('do_action')) do_action('after_products'); ?>
    </main>

    <!-- Cart Drawer -->
    <div x-show="cartOpen" x-cloak class="relative z-50">
        <div x-show="cartOpen" x-transition.opacity class="fixed inset-0 bg-slate-900/40 backdrop-blur-sm" @click="cartOpen = false"></div>

        <div class="fixed inset-0 overflow-hidden pointer-events-none">
            <div class="absolute inset-0 overflow-hidden">
                <div class="pointer-events-none fixed inset-y-0 <?= ($dir == 'rtl') ? 'left-0' : 'right-0' ?> flex max-w-full pl-0 sm:pl-10">
                    <div x-show="cartOpen"
                         x-transition:enter="transform transition ease-in-out duration-300"
                         x-transition:enter-start="<?= ($dir == 'rtl') ? '-translate-x-full' : 'translate-x-full' ?>"
                         x-transition:enter-end="translate-x-0"
                         x-transition:leave="transform transition ease-in-out duration-300"
                         x-transition:leave-start="translate-x-0"
                         x-transition:leave-end="<?= ($dir == 'rtl') ? '-translate-x-full' : 'translate-x-full' ?>"
                         class="pointer-events-auto w-screen max-w-md">
                        
                        <div class="flex h-full flex-col bg-white shadow-2xl">
                            <div class="flex items-center justify-between px-6 py-5 border-b border-slate-100 bg-white z-10">
                                <h2 class="text-lg font-bold text-slate-800 flex items-center gap-3">
                                    <?= __('cart') ?>
                                    <span class="bg-primary-50 text-primary-700 text-xs px-2.5 py-1 rounded-full font-bold border border-primary-100" x-text="count + ' منتج'"></span>
                                </h2>
                                <button @click="cartOpen = false" class="text-slate-400 hover:text-red-500 bg-slate-50 hover:bg-red-50 p-2 rounded-full">
                                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
                                </button>
                            </div>

                            <div class="flex-1 overflow-y-auto p-6 bg-slate-50/50">
                                <template x-if="cart.length === 0">
                                    <div class="h-full flex flex-col items-center justify-center text-slate-400 opacity-70 gap-4">
                                        <svg class="w-12 h-12 text-slate-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                                        <p class="font-medium"><?= __('empty_cart') ?></p>
                                    </div>
                                </template>

                                <ul class="space-y-4">
                                    <template x-for="(item, index) in cart" :key="index">
                                        <li class="bg-white p-3 rounded-2xl border border-slate-100 shadow-sm flex gap-4">
                                            <div class="w-20 h-20 flex-shrink-0 bg-slate-100 rounded-xl overflow-hidden relative">
                                                <img :src="item.image" class="w-full h-full object-cover" onerror="this.src='https://placehold.co/100x100?text=IMG'">
                                            </div>

                                            <div class="flex-1 flex flex-col justify-between">
                                                <div>
                                                    <div class="flex justify-between items-start">
                                                        <h4 class="font-bold text-slate-800 text-sm line-clamp-1" x-text="item.title"></h4>
                                                        <button @click="remove(index)" class="text-slate-300 hover:text-red-500"><svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg></button>
                                                    </div>
                                                    
                                                    <div class="flex flex-wrap gap-2 mt-1.5">
                                                        <template x-if="item.variant_color">
                                                            <span class="text-[10px] bg-slate-50 border border-slate-100 text-slate-500 px-1.5 py-0.5 rounded flex items-center gap-1">
                                                                <span class="w-2 h-2 rounded-full inline-block ring-1 ring-slate-200" :style="'background-color:'+item.variant_color"></span>
                                                                <span x-text="item.variant_color"></span>
                                                            </span>
                                                        </template>
                                                        <template x-if="item.variant_size">
                                                            <span class="text-[10px] bg-slate-50 border border-slate-100 text-slate-500 px-1.5 py-0.5 rounded" x-text="item.variant_size"></span>
                                                        </template>
                                                    </div>
                                                </div>

                                                <div class="flex justify-between items-end mt-2">
                                                    <div class="flex items-center bg-slate-50 rounded-lg border border-slate-200 h-8">
                                                        <button @click="updateQty(index, -1)" class="w-8 h-full flex items-center justify-center text-slate-500 hover:bg-slate-200 rounded-s-lg">-</button>
                                                        <span class="px-2 text-xs font-bold text-slate-800 w-6 text-center" x-text="item.qty"></span>
                                                        <button @click="updateQty(index, 1)" class="w-8 h-full flex items-center justify-center text-slate-500 hover:bg-slate-200 rounded-e-lg">+</button>
                                                    </div>
                                                    <span class="text-sm font-bold text-primary-600" x-text="(item.price * item.qty).toFixed(2) + ' ' + currencySymbol"></span>
                                                </div>
                                            </div>
                                        </li>
                                    </template>
                                </ul>
                            </div>

                            <div class="border-t border-slate-100 bg-white p-6 shadow-[0_-10px_40px_rgba(0,0,0,0.05)] z-20">
                                <div class="flex justify-between items-center mb-6">
                                    <span class="text-slate-500 text-sm font-medium"><?= __('total') ?></span>
                                    <span class="text-2xl font-extrabold text-slate-900" x-text="total + ' ' + currencySymbol"></span>
                                </div>
                                
                                <div class="space-y-4 mb-5">
                                    <input type="text" x-model="name" placeholder="<?= __('name') ?>" class="w-full bg-slate-50 px-4 py-3 border border-slate-200 rounded-xl focus:bg-white focus:border-primary-500 outline-none transition-all duration-200 text-sm">
                                    <input type="tel" x-model="phone" placeholder="<?= ($current_lang == 'ar') ? 'رقم الهاتف' : 'Phone Number' ?>" class="w-full bg-slate-50 px-4 py-3 border border-slate-200 rounded-xl focus:bg-white focus:border-primary-500 outline-none transition-all duration-200 text-sm">
                                    <textarea x-model="address" placeholder="<?= __('address') ?>" rows="2" class="w-full bg-slate-50 px-4 py-3 border border-slate-200 rounded-xl focus:bg-white focus:border-primary-500 outline-none transition-all duration-200 text-sm resize-none"></textarea>
                                </div>

                                <button @click="smartCheckout" :disabled="cart.length === 0 || isProcessing" class="w-full bg-slate-900 text-white py-4 rounded-xl font-bold hover:bg-primary-600 transition-all disabled:bg-slate-300 flex justify-center items-center gap-3">
                                    <span x-show="!isProcessing"><?= $btn_text ?></span>
                                    <span x-show="isProcessing"><?= $loading_text ?></span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(function_exists('do_action')) do_action('site_footer'); ?>

    <script>
        document.addEventListener('alpine:init', () => {
            
            // دالة منطق المنتج الواحد (مع التبعية)
            Alpine.data('productItem', (data) => ({
                item: data,
                selectedColor: null,
                selectedSize: null,

                init() {
                    // اختيار تلقائي إذا كان هناك خيار واحد ومتوفر
                    if(this.availableColors && this.availableColors.length === 1 && this.availableColors[0].inStock) {
                        this.selectedColor = this.availableColors[0].color;
                    }
                    if(this.availableSizes && this.availableSizes.length === 1 && this.availableSizes[0].inStock) {
                        this.selectedSize = this.availableSizes[0].size;
                    }
                },

                // حساب الألوان المتاحة (مع فلترة المخزون الـ 0)
                get availableColors() {
                    if (this.selectedSize) {
                        const relevantVariants = this.item.variants.filter(v => v.size === this.selectedSize && v.qty > 0);
                        const uniqueColors = [...new Set(relevantVariants.map(v => v.color))];
                        return uniqueColors.map(c => ({ color: c, inStock: relevantVariants.some(v => v.color === c && v.qty > 0) }));
                    }
                    const uniqueColors = [...new Set(this.item.variants.map(v => v.color))];
                    // إخفاء الألوان غير المتاحة تماماً (Stock 0)
                    return uniqueColors.map(c => ({ color: c, inStock: this.item.variants.some(v => v.color === c && v.qty > 0) })).filter(c => c.inStock);
                },

                // حساب المقاسات المتاحة (مع فلترة المخزون الـ 0)
                get availableSizes() {
                    if (this.selectedColor) {
                        const relevantVariants = this.item.variants.filter(v => v.color === this.selectedColor && v.qty > 0);
                        const uniqueSizes = [...new Set(relevantVariants.map(v => v.size))];
                        return uniqueSizes.map(s => ({ size: s, inStock: relevantVariants.some(v => v.size === s && v.qty > 0) }));
                    }
                    const uniqueSizes = [...new Set(this.item.variants.map(v => v.size))];
                    // إخفاء المقاسات غير المتاحة تماماً (Stock 0)
                    return uniqueSizes.map(s => ({ size: s, inStock: this.item.variants.some(v => v.size === s && v.qty > 0) })).filter(s => s.inStock);
                },

                selectColor(color) {
                    this.selectedColor = color;
                    const isCurrentSizeAvailable = this.availableSizes.some(s => s.size === this.selectedSize && s.inStock);
                    if (!isCurrentSizeAvailable) {
                        this.selectedSize = null;
                    }
                    if (this.availableSizes.length === 1 && this.availableSizes[0].inStock) {
                        this.selectedSize = this.availableSizes[0].size;
                    }
                },

                selectSize(size) {
                    this.selectedSize = size;
                    const isCurrentColorAvailable = this.availableColors.some(c => c.color === this.selectedColor && c.inStock);
                    if (!isCurrentColorAvailable) {
                        this.selectedColor = null;
                    }
                },

                addToCart() {
                    if (this.availableColors && this.availableColors.length > 0 && !this.selectedColor) { alert('<?= $select_msg ?>'); return; }
                    if (this.availableSizes && this.availableSizes.length > 0 && !this.selectedSize) { alert('<?= $select_msg ?>'); return; }

                    if (this.selectedColor) {
                         const colorObj = this.item.variants.find(c => c.color === this.selectedColor && c.size === this.selectedSize);
                         if(colorObj && colorObj.qty <= 0) { alert('عذراً، هذا المنتج غير متوفر في المخزون حالياً'); return; }
                    }

                    this.$dispatch('add-to-cart', { id: this.item.id, title: this.item.title, price: this.item.price, image: this.item.image, variant_color: this.selectedColor, variant_size: this.selectedSize });
                }
            }));

            Alpine.data('app', () => ({
                cartOpen: false,
                cart: JSON.parse(localStorage.getItem('cart')) || [],
                name: localStorage.getItem('user_name') || '',
                phone: localStorage.getItem('user_phone') || '',
                address: localStorage.getItem('user_address') || '',
                isProcessing: false,
                
                get count() { return this.cart.reduce((a, b) => a + b.qty, 0); },
                get total() { return this.cart.reduce((a, b) => a + (b.price * b.qty), 0).toFixed(2); },

                init() {
                    window.addEventListener('add-to-cart', (e) => this.add(e.detail));
                },

                add(data) {
                    let item = this.cart.find(i => 
                        i.id === data.id && i.variant_color === data.variant_color && i.variant_size === data.variant_size
                    );
                    if (item) item.qty++;
                    else this.cart.push({ ...data, qty: 1 });
                    
                    this.save();
                    this.cartOpen = true;
                },

                remove(index) { 
                    this.cart.splice(index, 1); this.save(); 
                },

                updateQty(index, change) {
                    if (this.cart[index].qty + change > 0) this.cart[index].qty += change;
                    else this.remove(index);
                    this.save();
                },

                save() { 
                    localStorage.setItem('cart', JSON.stringify(this.cart)); 
                },
                
                smartCheckout() {
                    if (!this.name || !this.address || !this.phone) { 
                        alert('<?= $fill_msg ?>'); 
                        return; 
                    }
                    
                    this.isProcessing = true;
                    
                    localStorage.setItem('user_name', this.name);
                    localStorage.setItem('user_phone', this.phone);
                    localStorage.setItem('user_address', this.address);

                    let msg = `🛒 *طلب جديد*\n\n`;
                    msg += `👤 *الاسم:* ${this.name}\n`;
                    msg += `📱 *رقم الهاتف:* ${this.phone}\n`;
                    msg += `📍 *العنوان:* ${this.address}\n`;
                    msg += `📅 *التاريخ:* ${new Date().toLocaleString('ar-EG')}\n`;
                    msg += `------------------------\n`;
                    msg += `📦 *تفاصيل الطلب:*`;
                    
                    this.cart.forEach((item, index) => {
                        msg += `\n\n${index + 1}. *${item.title}*`;
                        let productUrl = window.location.origin + window.location.pathname + "?id=" + item.id;
                        msg += `\n🔗 الرابط: ${productUrl}`;
                        
                        let details = [];
                        if(item.variant_size) details.push(`المقاس: ${item.variant_size}`);
                        if(item.variant_color) details.push(`اللون: ${item.variant_color}`);
                        
                        if(details.length > 0) {
                            msg += `\n📝 التفاصيل: ${details.join(' | ')}`;
                        }
                        
                        let itemPrice = parseFloat(item.price).toFixed(2);
                        let itemTotal = (parseFloat(item.price) * item.qty).toFixed(2);
                        msg += `\n💰 السعر: ${itemPrice} ${currencySymbol} x ${item.qty} = ${itemTotal} ${currencySymbol}`;
                    });

                    msg += `\n\n------------------------\n`;
                    msg += `💰 *الإجمالي:* ${this.total} ${currencySymbol}`;
                    msg += `\n\nشكراً لتعاملكم معنا!`;

                    let formData = new FormData();
                    formData.append('action', 'submit_order');
                    formData.append('name', this.name);
                    formData.append('phone', this.phone);
                    formData.append('address', this.address);
                    formData.append('cart', JSON.stringify(this.cart));
                    formData.append('total', this.total);
                    formData.append('wa_message', msg);

                    fetch('index.php', { method: 'POST', body: formData })
                    .then(r => r.json())
                    .then(() => {
                        window.open(`https://wa.me/${whatsappNumber}?text=${encodeURIComponent(msg)}`, '_blank');
                        this.cart = []; 
                        this.save(); 
                        this.cartOpen = false; 
                        this.isProcessing = false;
                    })
                    .catch((error) => {
                        console.log("Error fetching index.php", error);
                        window.open(`https://wa.me/${whatsappNumber}?text=${encodeURIComponent(msg)}`, '_blank');
                        this.isProcessing = false;
                    });
                }
            }));
        });
    </script>
</body>
</html>