<?php
/*
Plugin Name: واجهة الهيرو (Hero Section)
Plugin Key: hero_pro
Description: التحكم في بانر الصفحة الرئيسية (صورة، نص، أزرار).
*/

// ============================================================
// 1. زر القائمة الجانبية (عشان يظهر في الداش بورد)
// ============================================================
function hero_sidebar_link_v3() {
    // كود لتحديد الزر النشط (Active State)
    $is_active = (isset($_GET['tool']) && $_GET['tool'] == 'hero_pro');
    $active_class = $is_active ? 'bg-emerald-600 text-white shadow-lg' : 'text-slate-300 hover:bg-slate-800 hover:text-white';
    
    echo '<a href="plugins.php?tool=hero_pro" class="flex items-center gap-3 px-4 py-3 rounded-xl transition '.$active_class.'">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            <span>إعدادات الهيرو</span>
          </a>';
}
add_action('admin_sidebar', 'hero_sidebar_link_v3');


// ============================================================
// 2. إنشاء الجدول في قاعدة البيانات (أول مرة فقط)
// ============================================================
global $pdo;
if ($pdo) {
    $pdo->exec("CREATE TABLE IF NOT EXISTS `hero_settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `mode` varchar(50) DEFAULT 'both',
        `heading` varchar(255) DEFAULT '',
        `subheading` text,
        `btn_text` varchar(100) DEFAULT '',
        `btn_url` varchar(255) DEFAULT '#',
        `image_path` varchar(255) DEFAULT '',
        `overlay_opacity` int(11) DEFAULT 60,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

    // إنشاء صف افتراضي لو الجدول فاضي
    $check = $pdo->query("SELECT count(*) FROM hero_settings")->fetchColumn();
    if ($check == 0) {
        $pdo->exec("INSERT INTO hero_settings (mode, heading, subheading, btn_text) VALUES ('text_only', 'مرحباً بك', 'نص تجريبي', 'تصفح')");
    }
}


// ============================================================
// 3. صفحة الإعدادات (بتصميم لوحة التحكم الكامل)
// ============================================================
if (isset($_GET['tool']) && $_GET['tool'] == 'hero_pro') {
    hero_render_full_page();
    exit; // نوقف تحميل أي حاجة تانية عشان الصفحة دي تظهر لوحدها
}

function hero_render_full_page() {
    global $pdo;
    $msg = '';

    // -- معالجة الحفظ --
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $img = $_POST['curr_img'];
        // رفع الصورة
        if (!empty($_FILES['h_img']['name'])) {
            $target = "../assets/uploads/";
            if(!is_dir($target)) mkdir($target, 0755, true);
            $fn = time() . '_' . basename($_FILES['h_img']['name']);
            if(move_uploaded_file($_FILES['h_img']['tmp_name'], $target . $fn)) {
                $img = $fn;
            }
        }
        // تحديث البيانات
        $stmt = $pdo->prepare("UPDATE hero_settings SET mode=?, heading=?, subheading=?, btn_text=?, btn_url=?, overlay_opacity=?, image_path=? WHERE id=1");
        $stmt->execute([$_POST['mode'], $_POST['heading'], $_POST['subh'], $_POST['btn'], $_POST['url'], $_POST['op'], $img]);
        $msg = "تم حفظ التعديلات بنجاح ✅";
    }

    // جلب البيانات للعرض
    $row = $pdo->query("SELECT * FROM hero_settings LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    ?>
    <!DOCTYPE html>
    <html lang="ar" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <title>إعدادات الهيرو - لوحة التحكم</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
        <style>body { font-family: 'Cairo', sans-serif; }</style>
    </head>
    <body class="bg-gray-50">

    <div class="flex h-screen overflow-hidden">
        
        <aside class="w-64 bg-slate-900 text-white hidden md:flex flex-col shadow-2xl">
            <div class="h-20 flex items-center justify-center border-b border-slate-800">
                <h2 class="text-2xl font-bold text-emerald-400">WhatsCart</h2>
            </div>
            <nav class="flex-1 px-4 py-6 space-y-2 overflow-y-auto">
                <a href="index.php" class="flex items-center gap-3 px-4 py-3 text-slate-300 hover:bg-slate-800 hover:text-white rounded-xl transition">
                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" /></svg>
                    الرئيسية
                </a>
                <a href="products.php" class="flex items-center gap-3 px-4 py-3 text-slate-300 hover:bg-slate-800 hover:text-white rounded-xl transition">
                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" /></svg>
                    المنتجات
                </a>
                <a href="plugins.php" class="flex items-center gap-3 px-4 py-3 bg-emerald-600 text-white rounded-xl shadow-lg transition">
                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a2 2 0 012 2v6a2 2 0 01-2 2H9a2 2 0 01-2-2V6a2 2 0 012-2h2.5L11 4zm5 4h.01M8 16h.01" /></svg>
                    الإضافات
                </a>
                
                <?php if(function_exists('do_action')) do_action('admin_sidebar'); ?>

                <div class="border-t border-slate-800 my-2"></div>
                <a href="settings.php" class="flex items-center gap-3 px-4 py-3 text-slate-300 hover:bg-slate-800 hover:text-white rounded-xl transition">
                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                    الإعدادات
                </a>
            </nav>
            <div class="p-4 border-t border-slate-800">
                <a href="logout.php" class="flex items-center gap-2 text-red-400 hover:text-red-300 transition text-sm font-bold">
                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" /></svg>
                    تسجيل خروج
                </a>
            </div>
        </aside>

        <main class="flex-1 overflow-y-auto">
            <header class="bg-white shadow-sm p-4 md:hidden flex justify-between items-center">
                <span class="font-bold text-lg text-emerald-600">WhatsCart</span>
                <a href="logout.php" class="text-red-500 text-sm">خروج</a>
            </header>

            <div class="p-8">
                <div class="flex justify-between items-center mb-8">
                    <h1 class="text-2xl font-bold text-gray-800 flex items-center gap-2">
                        <span class="text-3xl">🎨</span> إعدادات واجهة الهيرو
                    </h1>
                    <a href="plugins.php" class="bg-white border text-gray-600 px-4 py-2 rounded-lg hover:bg-gray-50 transition">← عودة للإضافات</a>
                </div>

                <?php if($msg): ?>
                    <div class="bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl mb-6 flex items-center gap-2 shadow-sm">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>
                        <?= $msg ?>
                    </div>
                <?php endif; ?>

                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-8">
                        <form method="POST" enctype="multipart/form-data" class="space-y-8">
                            
                            <div>
                                <label class="block text-sm font-bold text-gray-700 mb-3">طريقة العرض</label>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <label class="cursor-pointer group relative">
                                        <input type="radio" name="mode" value="both" class="peer sr-only" <?= $row['mode']=='both'?'checked':'' ?>>
                                        <div class="p-4 rounded-xl border-2 border-gray-200 peer-checked:border-emerald-500 peer-checked:bg-emerald-50 hover:border-emerald-200 transition text-center h-full">
                                            <span class="text-3xl block mb-2">🖼️ + 📝</span>
                                            <span class="font-bold text-gray-700">صورة ونص</span>
                                        </div>
                                        <div class="absolute top-2 right-2 text-emerald-600 opacity-0 peer-checked:opacity-100 transition"><svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg></div>
                                    </label>
                                    
                                    <label class="cursor-pointer group relative">
                                        <input type="radio" name="mode" value="image_only" class="peer sr-only" <?= $row['mode']=='image_only'?'checked':'' ?>>
                                        <div class="p-4 rounded-xl border-2 border-gray-200 peer-checked:border-emerald-500 peer-checked:bg-emerald-50 hover:border-emerald-200 transition text-center h-full">
                                            <span class="text-3xl block mb-2">🖼️</span>
                                            <span class="font-bold text-gray-700">صورة فقط</span>
                                        </div>
                                        <div class="absolute top-2 right-2 text-emerald-600 opacity-0 peer-checked:opacity-100 transition"><svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg></div>
                                    </label>

                                    <label class="cursor-pointer group relative">
                                        <input type="radio" name="mode" value="text_only" class="peer sr-only" <?= $row['mode']=='text_only'?'checked':'' ?>>
                                        <div class="p-4 rounded-xl border-2 border-gray-200 peer-checked:border-emerald-500 peer-checked:bg-emerald-50 hover:border-emerald-200 transition text-center h-full">
                                            <span class="text-3xl block mb-2">📝</span>
                                            <span class="font-bold text-gray-700">نص فقط</span>
                                        </div>
                                        <div class="absolute top-2 right-2 text-emerald-600 opacity-0 peer-checked:opacity-100 transition"><svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg></div>
                                    </label>
                                </div>
                            </div>

                            <hr class="border-gray-100">

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2">العنوان الرئيسي</label>
                                    <input type="text" name="heading" value="<?= htmlspecialchars($row['heading']) ?>" class="w-full p-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-emerald-500 focus:outline-none transition bg-gray-50 focus:bg-white" placeholder="أهلاً بك في متجرنا...">
                                </div>
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2">الوصف الفرعي</label>
                                    <input type="text" name="subh" value="<?= htmlspecialchars($row['subheading']) ?>" class="w-full p-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-emerald-500 focus:outline-none transition bg-gray-50 focus:bg-white" placeholder="اكتشف أحدث العروض...">
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm font-bold text-gray-700 mb-2">صورة البانر / الخلفية</label>
                                <div class="border-2 border-dashed border-gray-300 rounded-xl p-8 text-center bg-gray-50 hover:bg-white hover:border-emerald-400 transition relative">
                                    <?php if($row['image_path']): ?>
                                        <img src="../assets/uploads/<?= $row['image_path'] ?>" class="h-40 mx-auto rounded-lg shadow-md mb-4 object-cover border border-gray-200">
                                        <p class="text-xs text-green-600 font-bold mb-4">✅ الصورة الحالية مستخدمة</p>
                                    <?php else: ?>
                                        <div class="h-32 flex flex-col items-center justify-center text-gray-400 mb-2">
                                            <svg class="w-16 h-16 mb-2 text-gray-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                            <span>اضغط لاختيار صورة جديدة</span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <input type="file" name="h_img" accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                                    <input type="hidden" name="curr_img" value="<?= $row['image_path'] ?>">
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 bg-gray-50 p-6 rounded-xl border border-gray-100">
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2">نص الزر</label>
                                    <input type="text" name="btn" value="<?= htmlspecialchars($row['btn_text']) ?>" placeholder="تسوق الآن" class="w-full p-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-emerald-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2">رابط الزر (URL)</label>
                                    <input type="text" name="url" value="<?= htmlspecialchars($row['btn_url']) ?>" placeholder="#" class="w-full p-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-emerald-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2">تعتيم الخلفية (<?= $row['overlay_opacity'] ?>%)</label>
                                    <input type="range" name="op" value="<?= $row['overlay_opacity'] ?>" min="0" max="90" class="w-full h-2 bg-gray-200 rounded-lg appearance-none cursor-pointer accent-emerald-600 mt-4">
                                </div>
                            </div>

                            <button type="submit" class="w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-lg hover:bg-slate-800 transition shadow-lg flex justify-center items-center gap-2 transform active:scale-95">
                                <span>حفظ كافة التغييرات</span>
                                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>
    </body>
    </html>
    <?php
}

// ============================================================
// 4. عرض الهيرو في الموقع (Frontend)
// ============================================================
function render_hero_frontend() {
    global $pdo;
    try { $h = $pdo->query("SELECT * FROM hero_settings LIMIT 1")->fetch(PDO::FETCH_ASSOC); } catch (Exception $e) { return; }
    if (!$h) return;

    $img_url = 'assets/uploads/' . $h['image_path'];
    $overlay = $h['overlay_opacity'] / 100;

    if ($h['mode'] == 'image_only' && !empty($h['image_path'])) {
        echo '<div class="w-full mb-8 fade-in"><a href="'.htmlspecialchars($h['btn_url']).'" class="block group overflow-hidden rounded-2xl shadow-sm"><img src="'.$img_url.'" class="w-full h-auto max-h-[450px] object-cover transition duration-700 group-hover:scale-105"></a></div>';
    } elseif ($h['mode'] == 'text_only') {
        echo '<div class="w-full mb-8 fade-in"><div class="bg-gradient-to-br from-emerald-600 to-teal-800 rounded-2xl p-10 md:p-16 text-center text-white shadow-lg relative overflow-hidden"><h2 class="text-3xl md:text-5xl font-bold mb-4 relative z-10">'.htmlspecialchars($h['heading']).'</h2><p class="text-emerald-100 text-lg md:text-xl mb-8 max-w-2xl mx-auto relative z-10">'.htmlspecialchars($h['subheading']).'</p>'.($h['btn_text'] ? '<a href="'.htmlspecialchars($h['btn_url']).'" class="inline-block bg-white text-emerald-700 px-8 py-3.5 rounded-full font-bold hover:bg-yellow-400 hover:text-emerald-900 transition shadow-lg relative z-10">'.$h['btn_text'].'</a>' : '').'</div></div>';
    } elseif ($h['mode'] == 'both') {
        $bg = !empty($h['image_path']) ? "background-image: url('$img_url');" : "background-color: #333;";
        echo '<div class="w-full mb-8 fade-in"><div class="relative w-full h-[350px] md:h-[450px] rounded-2xl overflow-hidden shadow-lg group"><div class="absolute inset-0 bg-cover bg-center transition duration-[2s] group-hover:scale-110" style="'.$bg.'"></div><div class="absolute inset-0 bg-black transition duration-500" style="opacity: '.$overlay.';"></div><div class="absolute inset-0 flex flex-col justify-center items-center text-center p-6 z-10"><h2 class="text-4xl md:text-6xl font-bold text-white mb-4 drop-shadow-lg tracking-tight">'.htmlspecialchars($h['heading']).'</h2><p class="text-gray-100 text-lg md:text-2xl mb-8 max-w-3xl drop-shadow-md font-light">'.htmlspecialchars($h['subheading']).'</p>'.($h['btn_text'] ? '<a href="'.htmlspecialchars($h['btn_url']).'" class="bg-emerald-500 text-white px-10 py-4 rounded-full font-bold text-lg hover:bg-emerald-600 hover:-translate-y-1 transition-all shadow-xl border-2 border-emerald-400/30 backdrop-blur-sm">'.$h['btn_text'].'</a>' : '').'</div></div></div>';
    }
}
add_action('after_navbar', 'render_hero_frontend');
?>