<?php
/*
Plugin Name: شريط السوشيال ميديا الاحترافي (Smart Social Pro)
Plugin Key: smart_social
Description: إضافة أيقونات التواصل بتصميم احترافي (Official Vectors) وتأثيرات بصرية حديثة.
Version: 3.0 (Professional Edition)
*/

// ============================================================
// 1. إعداد قاعدة البيانات (Setup DB)
// ============================================================
global $pdo;
if ($pdo) {
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS `ssb_socials` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `platform` varchar(50) NOT NULL,
            `url` varchar(255) DEFAULT '',
            `is_active` tinyint(1) DEFAULT 0,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

        // إضافة المنصات الافتراضية إذا كان الجدول فارغاً
        $check = $pdo->query("SELECT count(*) FROM ssb_socials")->fetchColumn();
        if ($check == 0) {
            $defaults = ['whatsapp', 'facebook', 'instagram', 'tiktok', 'snapchat', 'twitter', 'youtube', 'telegram'];
            $stmt = $pdo->prepare("INSERT INTO ssb_socials (platform, is_active) VALUES (?, 0)");
            foreach ($defaults as $p) {
                $stmt->execute([$p]);
            }
        }
    } catch (Exception $e) {}
}

// ============================================================
// 2. رابط القائمة الجانبية (Admin Sidebar)
// ============================================================
if (!function_exists('ssb_pro_sidebar')) {
    function ssb_pro_sidebar() {
        $active = (isset($_GET['tool']) && $_GET['tool'] == 'smart_social') ? 'bg-indigo-600 text-white shadow-lg' : 'text-slate-300 hover:bg-slate-800';
        echo '<a href="plugins.php?tool=smart_social" class="flex items-center gap-3 px-4 py-3 rounded-xl transition '.$active.'">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1" /></svg>
                <span>روابط السوشيال</span>
              </a>';
    }
    add_action('admin_sidebar', 'ssb_pro_sidebar');
}

// ============================================================
// 3. صفحة الإدارة (Admin Dashboard)
// ============================================================
if (isset($_GET['tool']) && $_GET['tool'] == 'smart_social') {
    ssb_pro_admin_page();
    exit;
}

function ssb_pro_admin_page() {
    global $pdo;
    $msg = '';

    // حفظ البيانات
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_ssb'])) {
        $platforms = $_POST['socials'];
        // تصفير النشاط
        $pdo->exec("UPDATE ssb_socials SET is_active = 0");
        if(is_array($platforms)) {
            foreach ($platforms as $id => $data) {
                $url = trim($data['url']);
                $active = isset($data['active']) ? 1 : 0;
                $stmt = $pdo->prepare("UPDATE ssb_socials SET url = ?, is_active = ? WHERE id = ?");
                $stmt->execute([$url, $active, $id]);
            }
        }
        $msg = "تم تحديث الروابط وتفعيل الأيقونات بنجاح ✅";
    }

    $socials = $pdo->query("SELECT * FROM ssb_socials ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
    
    // تعريف الأيقونات بلوحة التحكم (للعرض فقط)
    $meta = [
        'whatsapp'  => ['name' => 'WhatsApp',  'color' => 'text-green-600', 'bg' => 'bg-green-50'],
        'facebook'  => ['name' => 'Facebook',  'color' => 'text-blue-600',  'bg' => 'bg-blue-50'],
        'instagram' => ['name' => 'Instagram', 'color' => 'text-pink-600',  'bg' => 'bg-pink-50'],
        'tiktok'    => ['name' => 'TikTok',    'color' => 'text-black',     'bg' => 'bg-gray-100'],
        'snapchat'  => ['name' => 'Snapchat',  'color' => 'text-yellow-500','bg' => 'bg-yellow-50'],
        'twitter'   => ['name' => 'X (Twitter)','color' => 'text-gray-800',  'bg' => 'bg-gray-100'],
        'youtube'   => ['name' => 'YouTube',   'color' => 'text-red-600',   'bg' => 'bg-red-50'],
        'telegram'  => ['name' => 'Telegram',  'color' => 'text-blue-500',  'bg' => 'bg-blue-50'],
    ];
    ?>
    <!DOCTYPE html>
    <html lang="ar" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <title>إدارة السوشيال ميديا</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
        <style>body { font-family: 'Cairo', sans-serif; }</style>
    </head>
    <body class="bg-gray-50 flex h-screen overflow-hidden">
        <aside class="w-64 bg-slate-900 text-white hidden md:flex flex-col shadow-2xl">
            <div class="h-20 flex items-center justify-center border-b border-slate-800"><h2 class="text-2xl font-bold text-emerald-400">WhatsCart</h2></div>
            <nav class="flex-1 px-4 py-6 space-y-2"><a href="plugins.php" class="flex items-center gap-3 px-4 py-3 bg-indigo-600 text-white rounded-xl shadow-lg">رجوع</a></nav>
        </aside>

        <main class="flex-1 overflow-y-auto p-8">
            <h1 class="text-2xl font-bold text-gray-800 mb-6">💎 إعدادات شريط التواصل الاحترافي</h1>
            <?php if($msg): ?><div class="bg-green-100 text-green-700 p-4 rounded-xl mb-6 font-bold text-center border border-green-200"><?= $msg ?></div><?php endif; ?>

            <form method="POST" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <div class="grid gap-4">
                    <?php foreach($socials as $s): 
                        $info = $meta[$s['platform']] ?? ['name' => ucfirst($s['platform']), 'color' => 'text-gray-600', 'bg' => 'bg-gray-50'];
                    ?>
                    <div class="flex items-center gap-4 p-4 border rounded-lg hover:bg-gray-50 transition group">
                        <div class="flex items-center">
                            <input type="checkbox" name="socials[<?= $s['id'] ?>][active]" value="1" <?= $s['is_active'] ? 'checked' : '' ?> class="w-5 h-5 cursor-pointer accent-indigo-600 rounded">
                        </div>
                        
                        <div class="w-32 font-bold <?= $info['color'] ?> flex items-center gap-2">
                            <?= $info['name'] ?>
                        </div>

                        <div class="flex-1">
                            <input type="url" name="socials[<?= $s['id'] ?>][url]" value="<?= htmlspecialchars($s['url']) ?>" 
                                   placeholder="https://<?= $s['platform'] ?>.com/..." 
                                   class="w-full border-gray-300 rounded-lg px-4 py-2 text-sm focus:ring-2 focus:ring-indigo-500 border outline-none text-left dir-ltr font-mono text-gray-600 transition group-hover:border-indigo-300">
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <div class="mt-6 text-left">
                    <button type="submit" name="save_ssb" class="bg-slate-900 text-white px-8 py-3 rounded-xl font-bold hover:bg-black transition shadow-lg transform hover:-translate-y-1">حفظ الإعدادات</button>
                </div>
            </form>
        </main>
    </body>
    </html>
    <?php
}

// ============================================================
// 4. الواجهة الأمامية (Frontend) - الأيقونات المعدلة هندسياً
// ============================================================
if (!function_exists('ssb_pro_frontend')) {
    function ssb_pro_frontend() {
        global $pdo;
        $links = $pdo->query("SELECT * FROM ssb_socials WHERE is_active = 1")->fetchAll(PDO::FETCH_ASSOC);
        
        if (empty($links)) return;

        // --------------------------------------------------------
        // مكتبة الأيقونات (SVG Paths) - تم التدقيق والمراجعة
        // ViewBox: 0 0 24 24 (موحد لجميع الأيقونات لضمان التناسق)
        // --------------------------------------------------------
        $icons = [
            'whatsapp' => [
                'path' => '<path d="M12.04 2c-5.46 0-9.91 4.45-9.91 9.91 0 1.75.46 3.45 1.32 4.95L2.05 22l5.25-1.38c1.45.79 3.08 1.21 4.74 1.21 5.46 0 9.91-4.45 9.91-9.91 0-2.65-1.03-5.14-2.9-7.01A9.816 9.816 0 0012.04 2m.01 16.61c-1.48 0-2.93-.4-4.21-1.15l-.3-.18-3.11.82.83-3.03-.2-.31a8.163 8.163 0 01-1.26-4.38c0-4.54 3.7-8.24 8.24-8.24 2.2 0 4.27.86 5.82 2.42a8.183 8.183 0 012.41 5.83c.02 4.54-3.68 8.22-8.22 8.22m4.52-6.16c-.25-.12-1.47-.72-1.69-.81-.23-.08-.39-.12-.56.12-.17.25-.64.81-.78.97-.14.17-.29.19-.54.06-.25-.12-1.05-.39-1.99-1.23-.74-.66-1.23-1.47-1.38-1.72-.14-.25-.02-.38.11-.51.11-.11.25-.29.37-.43.12-.15.16-.25.25-.41.08-.17.04-.31-.02-.43-.06-.12-.56-1.34-.76-1.84-.2-.48-.41-.42-.56-.43h-.48c-.17 0-.44.06-.67.31-.23.25-.88.86-.88 2.11s.9 2.45 1.02 2.61c.13.16 3.56 5.44 8.62 7.63 2.99 1.29 3.6 1.04 4.25.97.66-.07 1.47-.6 1.67-1.18.21-.58.21-1.07.15-1.18-.07-.11-.23-.17-.48-.3z"/>',
                'class' => 'text-green-500 hover:bg-green-500 hover:text-white'
            ],
            'facebook' => [
                'path' => '<path d="M18 2h-3a5 5 0 00-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 011-1h3z"/>',
                'class' => 'text-blue-600 hover:bg-blue-600 hover:text-white'
            ],
            'instagram' => [
                'path' => '<rect x="2" y="2" width="20" height="20" rx="5" ry="5" stroke-width="2" stroke="currentColor" fill="none"/><path d="M16 11.37A4 4 0 1112.63 8 4 4 0 0116 11.37z" stroke-width="2" stroke="currentColor" fill="none"/><line x1="17.5" y1="6.5" x2="17.51" y2="6.5" stroke-width="2" stroke="currentColor"/>',
                'class' => 'text-pink-600 hover:bg-gradient-to-tr hover:from-yellow-400 hover:via-red-500 hover:to-purple-500 hover:text-white'
            ],
            'tiktok' => [
                'path' => '<path d="M9 12a4 4 0 1 0 4 4V4a5 5 0 0 0 5 5"/>', // Simple note path
                // Using a more detailed path for TikTok to ensure it looks right
                'path_full' => '<path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64 2.93 2.93 0 0 1 .88.13V9.4a6.84 6.84 0 0 0-1-.05A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z"/>',
                'class' => 'text-black hover:bg-black hover:text-white'
            ],
            'snapchat' => [
                'path' => '<path d="M12.003 2c-3.264 0-5.877 2.308-5.962 5.253a4.795 4.795 0 0 0 .97 2.889c.772 1.055.772 1.604.28 2.067-.534.505-1.92.593-2.078.601-.84.048-1.25.437-1.216.924.038.544.606.84 1.132.84.093 0 .19-.01.284-.027.606-.118 1.503-.087 2.04.168.536.255.81.72.84 1.424.018.423-.19.897-.57 1.306-.39.418-.94.755-1.562 1.144-.75.47-1.458.913-1.644 1.666-.188.756.402 1.433 1.258 1.442.13.002.262-.015.394-.05 1.024-.265 1.815-.316 2.68.272.715.485 1.64.796 2.943.796h.423c1.303 0 2.228-.31 2.943-.796.865-.588 1.656-.537 2.68-.272.132.035.264.052.394.05 1.205 0 1.55-.956 1.258-1.442-.186-.753-.894-1.196-1.644-1.666-.622-.39-1.172-.726-1.562-1.144-.38-.41-.588-.883-.57-1.306.03-.704.304-1.17.84-1.424.537-.255 1.434-.286 2.04-.168.094.018.19.027.284.027.526 0 1.094-.296 1.132-.84.034-.487-.376-.876-1.216-.924-.158-.008-1.544-.096-2.078-.601-.492-.463-.492-1.012.28-2.067a4.795 4.795 0 0 0 .97-2.889C17.88 4.308 15.267 2 12.003 2z"/>',
                'class' => 'text-yellow-500 hover:bg-yellow-400 hover:text-white'
            ],
            'twitter' => [
                'path' => '<path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"/>', // Standard bird
                'path_full' => '<path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>', // X Logo
                'class' => 'text-gray-900 hover:bg-black hover:text-white'
            ],
            'youtube' => [
                'path' => '<path d="M22.54 6.42a2.78 2.78 0 0 0-1.94-2C18.88 4 12 4 12 4s-6.88 0-8.6.46a2.78 2.78 0 0 0-1.94 2A29 29 0 0 0 1 11.75a29 29 0 0 0 .46 5.33A2.78 2.78 0 0 0 3.4 19c1.72.46 8.6.46 8.6.46s6.88 0 8.6-.46a2.78 2.78 0 0 0 1.94-2 29 29 0 0 0 .46-5.25 29 29 0 0 0-.46-5.33zM9.75 15.02l5.75-3.27-5.75-3.27z"/>',
                'class' => 'text-red-600 hover:bg-red-600 hover:text-white'
            ],
            'telegram' => [
                'path' => '<line x1="22" y1="2" x2="11" y2="13"/><polygon points="22 2 15 22 11 13 2 9 22 2"/>',
                'class' => 'text-blue-500 hover:bg-blue-500 hover:text-white'
            ],
        ];

        echo '<div class="flex items-center gap-2">';
        foreach ($links as $link) {
            $plat = $link['platform'];
            if (!empty($link['url']) && isset($icons[$plat])) {
                $iconData = $icons[$plat];
                $svgContent = isset($iconData['path_full']) ? $iconData['path_full'] : $iconData['path'];
                
                // --- تصميم الأيقونة ---
                // w-9 h-9: حجم الدائرة الخارجية (للنقر المريح)
                // bg-gray-100: لون خلفية مبدئي هادئ
                // transition-all duration-300: نعومة الحركة
                // hover:-translate-y-1: حركة بسيطة للأعلى عند اللمس (احترافي)
                echo '<a href="'.htmlspecialchars($link['url']).'" target="_blank" 
                         title="'.ucfirst($plat).'"
                         class="w-9 h-9 flex items-center justify-center rounded-full bg-gray-100 transition-all duration-300 transform hover:-translate-y-1 shadow-sm hover:shadow-md ' . $iconData['class'] . '">';
                
                // w-5 h-5: حجم الأيقونة نفسها داخل الدائرة (متناسق)
                echo '<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" stroke="none" xmlns="http://www.w3.org/2000/svg">';
                echo $svgContent;
                echo '</svg></a>';
            }
        }
        echo '</div>';
    }
    
    // ربط الدالة بالهووك الموجود في الثيم
    add_action('navbar_buttons', 'ssb_pro_frontend');
}
?>